<?php
// Load vehicle data from a local JSON file
$vehicleFilePath = './data/vehicles.json';
$vehiclesJson = file_get_contents($vehicleFilePath);
$vehiclesData = json_decode($vehiclesJson, true);

// Extract the vehicle registrations into an array
$vehicles = array_column($vehiclesData, 'registration');
$make = array_column($vehiclesData, 'make');
$model = array_column($vehiclesData, 'model');

// Load API data from a local JSON file
$apiDataFilePath = '/tmp/natx.json';
$vehicleDataJson = file_get_contents($apiDataFilePath);
$vehicleData = json_decode($vehicleDataJson, true);

// Prepare map markers for vehicles in the local fleet
$markers = [];
foreach ($vehicleData['VehicleActivity'] as $activity) {
    $vehicleRef = $activity['MonitoredVehicleJourney']['VehicleRef'] ?? null;
    if (in_array($vehicleRef, $vehicles)) {
        $longitude = $activity['MonitoredVehicleJourney']['VehicleLocation']['Longitude'] ?? null;
        $latitude = $activity['MonitoredVehicleJourney']['VehicleLocation']['Latitude'] ?? null;

        if ($longitude && $latitude) {
            $markers[] = [
                'registration' => $vehicleRef,
                'line' => $activity['MonitoredVehicleJourney']['PublishedLineName'] ?? 'N/A',
                'longitude' => $longitude,
                'latitude' => $latitude,
                'origin' => $activity['MonitoredVehicleJourney']['OriginName'] ?? 'Unknown',
                'destination' => $activity['MonitoredVehicleJourney']['DestinationName'] ?? 'Unknown',
                'departure' => $activity['OriginAimedDepartureTime'] ?? false,
                'arrival' => $activity['DestinationAimedArrivalTime'] ?? false,
                'direction' => $activity['DirectionRef'] ?? false,
                'in_service' => $activity['Monitored'] ?? false,
                'recorded_at' => $activity['RecordedAtTime'] ?? 'N/A',
            ];
        }
    }
}
?>

<?php
$refresh_interval = 300; // Set the refresh interval (in seconds)
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="refresh" content="<?php echo $refresh_interval; ?>">
    <title>Skills Motor Coaches</title>
    <style>
        body {
            background-color: #007161;
            color: #007161;
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ccc;
            padding: 10px;
            vertical-align: top;
        }
        td {
            width: 15%;
        }
        td:nth-child(1) {
            text-align: center;
            background-color: #007161;
        }
        td:nth-child(2) {
            width: 70%;
            background-color: #007161;
        }
        td:nth-child(3) {
            background-color: #007161;
            text-align: left;
        }
        #map {
            width: 920px;
            height: 500px;
        }
        .vehicle-container {
            color: #007161;
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
        }
        .vehicle-box {
            width: 45%;
            margin: 5px;
            text-align: center;
            color: #007161;
        }
        .show-all-box {
            width: calc(45% - 10px);
            margin: 5px;
            text-align: center;
            color: #007161;
        }
        .clock {
            font-family: 'Courier New', monospace;
            font-size: 32px;
            letter-spacing: 5px;
            color: #007161;
            text-align: center;
        }
    </style>
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
    <link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
    <script>
        function updateClock() {
            const now = new Date();
            const hours = String(now.getHours()).padStart(2, '0');
            const minutes = String(now.getMinutes()).padStart(2, '0');
            const seconds = String(now.getSeconds()).padStart(2, '0');

            document.getElementById('clock').innerText = `${hours}:${minutes}:${seconds}`;
        }

        setInterval(updateClock, 1000);
    </script>
</head>
<body>
    <table style="color: bf7fbf; border-collapse: collapse; width: 100%;" border="0">
        <tr>
            <td colspan="2" style="width: 50%; background-color: White; text-align: left;">
                <div style="display: flex; align-items: center;">
                    <img src="images/logo_skills_nx.jpg" alt="Skills Motor Coaches National Express Logo" style="max-height: 50px; width: auto; margin-right: 10px;">
                    <span style="font-size: 24px; color: #007161;"><b>Fleet Tracker</b></span>
                </div>
            </td>
            <td colspan="2" style="width: 50%; background-color: White; text-align: right; color: #007161; vertical-align: middle;">
                <div style="display: flex; align-items: center; justify-content: flex-end;">
                    <font size="1px">Time: </font><div id="clock" class="clock" style="margin-right: 10px;"></div>
                    <font size="1px">Date: </font><div id="date" class="clock">
                    <?php 
                        date_default_timezone_set('Europe/London');
                        $currentDate = date('d/m/Y');
                        echo $currentDate;
                    ?>
                </div>
            </div>
        </td>
        </tr>
        <tr>
            <td rowspan="2">
                <font color="#ffffff">Select Vehicle </font>
                <br>
                <br>
                <center>
                <table border="0" style="width: 225px; border-collapse: collapse; text-align: center;">
                    <tr>
                        <td colspan="2">
                            <input class="show-all-box" type="text" value="SHOW ALL" readonly onclick="window.location.reload();" style="width: 92%; background-color: White; color: #007161; text-align: center; cursor: default;"></td>
                        </td>
                    </tr>
                    <tr>
                        <?php $count = 0; foreach ($vehicles as $vehicle) { if ($count % 2 == 0 && $count != 0) { echo '</tr><tr>'; } ?>
                        <td style="width: 50%; padding: 10px;">
                            <button style="width: 100%; background-color: white; color: #007161; font-size: 14px;">
                            <?php echo htmlspecialchars($vehicle); ?>
                            </button>
                        </td>
                        <?php $count++; } ?>
                   </tr>
               </table>
               </center>
               <pre><font color="White"></font></pre>
            </td>
            <td colspan="2">
                <div id="map"></div>
                <script>
                    var map = L.map('map').setView([52.38, -1.3], 7);
                    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                        maxZoom: 19,
                        attribution: '© <?php echo date('Y'); ?> OpenStreetMap'
                    }).addTo(map);

                    // Add markers for the vehicles in the local fleet
                    <?php foreach ($markers as $marker): ?>
                        var marker = L.marker([<?php echo $marker['latitude']; ?>, <?php echo $marker['longitude']; ?>], { icon: L.icon({ iconUrl: 'images/coach_icon.png', iconSize: [25, 41], iconAnchor: [12, 41] }) })
                            .addTo(map)
                            .bindPopup("<strong>Registration:</strong> <?php echo htmlspecialchars($marker['registration']); ?><br><strong>Line:</strong> <?php echo htmlspecialchars($marker['line']); ?><br><strong>Origin:</strong> <?php echo htmlspecialchars($marker['origin']); ?><br><strong>Destination:</strong> <?php echo htmlspecialchars($marker['destination']); ?><br><strong>Recorded At:</strong> <?php echo htmlspecialchars($marker['recorded_at']); ?>");
                    <?php endforeach; ?>

                    // Fit the map to the bounds of the markers
                    var group = L.featureGroup();
                    <?php foreach ($markers as $marker): ?>
                        group.addLayer(L.marker([<?php echo $marker['latitude']; ?>, <?php echo $marker['longitude']; ?>]));
                    <?php endforeach; ?>
                    map.fitBounds(group.getBounds());
                </script>
            </td>
            <td rowspan="2">
                <center>
                <font color="#ffffff">Tracked Vehicle </font>
                <br>
                <br>
                    <table style="width: 225px; border-collapse: collapse; text-align: left; font-size: 12px;">
                        <tr>
                            <td style="background-color: #ffffff; color: #007161; text-align: right; width: 100px; font-weight: bold;">VEHICLE:</td>
                            <td style="background-color: #007161; color: White; text-align: left; width: 100px;">BV73ZTO</td>
                        </tr>
                        <tr>
                            <td style="background-color: #ffffff; color: #007161; text-align: right; width: 100px; font-weight: bold;">MAKE:<br>MODEL:</td>
                            <td style="background-color: #007161; color: White; text-align: left; width: 100px;">Scania <br> K410CB6 Caetano Levante 3A</td>
                        </tr>
                        <tr>
                            <td style="background-color: #ffffff; color: #007161; text-align: right; width: 100px; font-weight: bold;">LINE:</td>
                            <td style="background-color: #007161; color: White; text-align: left; width: 100px;">240</td>
                        </tr>
                        <tr>
                            <td style="background-color: #ffffff; color: #007161; text-align: right; width: 100px; font-weight: bold;">DIRECTION:</td>
                            <td style="background-color: #007161; color: White; text-align: left; width: 100px;">Outbound</td>
                        </tr>
                        <tr>
                            <td style="background-color: #ffffff; color: #007161; text-align: right; width: 100px; font-weight: bold;">LATITUDE:</td>
                            <td style="background-color: #007161; color: White; text-align: left; width: 100px;">53.79710</td>
                        </tr>
                        <tr>
                            <td style="background-color: #ffffff; color: #007161; text-align: right; width: 100px; font-weight: bold;">LONGITUDE:</td>
                            <td style="background-color: #007161; color: White; text-align: left; width: 100px;">-1.53608</td>
                        </tr>
                        <tr>
                            <td style="background-color: #ffffff; color: #007161; text-align: right; width: 100px; font-weight: bold;">REPORT&nbsp;TIME:</td>
                            <td style="background-color: #007161; color: White; text-align: left; width: 100px;"><?php date_default_timezone_set('Europe/London'); $currentDateTime = date('H:i'); echo $currentDateTime . " Hrs"; ?></td>
                        </tr>
                    </table>
                </center>
                <br>
    
                <div>
                    <div style="display: flex; justify-content: center; align-items: center; gap: 10px;">
                        <a href="https://nationalexpress.com/" target="_blank" style="text-decoration: none;">
                            <div style="background-color: White; color: #007161; text-align: center; padding: 10px; border-radius: 10px; border: 1px solid #007161; width: 70px; height: 70px; display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                <img src="images/coach_icon.png" alt="National Express Logo" style="max-height: 110px; width: 68px; display: block; margin: 0 auto; border-radius: 8px;">
                            </div>
                        </a>
                        <a href="https://www.nxagents.com/" target="_blank" style="text-decoration: none;">
                            <div style="background-color: White; color: #007161; text-align: center; padding: 10px; border-radius: 10px; border: 1px solid #007161; width: 70px; height: 70px;">
                                <img src="images/nxagent.png" alt="National Express Agents" style="max-height: 68px; width: 68px; display: block; margin: 0 auto; border-radius: 8px;">
                                <span style="font-size: 14px; color: Black;">NX<br>Agents</span>
                            </div>
                        </a>
                </div>
                <div>
                    <div style="display: flex; justify-content: center; align-items: center; gap: 10px;">
                        <a href="https://nationalhighways.co.uk/travel-updates/road-closure-report/" target="_blank" style="text-decoration: none;">
                            <div style="background-color: White; color: #007161; text-align: center; padding: 10px; border-radius: 10px; border: 1px solid #007161; width: 70px; height: 70px; display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                <img src="images/national-highways_rgb.svg" alt="National Highways Logo" style="max-height: 120px; width: 68px; display: block; margin: 0 auto; border-radius: 8px;">
                                <span style="font-size: 14px; color: Black;"><br>Road<br>Closures</span>
                            </div>
                        </a>
                        <a href="https://www.trafficengland.com/traffic-report" target="_blank" style="text-decoration: none;">
                            <div style="background-color: White; color: #007161; text-align: center; padding: 10px; border-radius: 10px; border: 1px solid #007161; width: 70px; height: 70px; display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                <img src="images/national-highways_rgb.svg" alt="National Highways Logo" style="max-height: 120px; width: 68px; display: block; margin: 0 auto; border-radius: 8px;">
                                <span style="font-size: 14px; color: Black;"><br>Traffic<br>Report</span>
                            </div>
                        </a>
                    </div>
                </div>
                <div>
                    <div style="display: flex; justify-content: center; align-items: center; gap: 10px;">
                        <a href="https://www.gov.uk/guidance/the-highway-code" target="_blank" style="text-decoration: none;">
                            <div style="background-color: White; color: #007161; text-align: center; padding: 10px; border-radius: 10px; border: 1px solid #007161; width: 70px; height: 70px; display: flex; flex-direction: column; justify-content: center; align-items: center;">
                                <img src="images/govuk.png" alt="GOV.UK" style="max-height: 120px; width: 68px; display: block; margin: 0 auto; border-radius: 8px;">
                                <span style="font-size: 14px; color: Black;">The<br>Highway<br>Code</span>
                            </div>
                        </a>
                        <a href="https://www.skills.co.uk/" target="_blank" style="text-decoration: none;">
                            <div style="background-color: White; color: #007161; text-align: center; padding: 10px; border-radius: 10px; border: 1px solid #007161; width: 70px; height: 70px;">
                                <img src="images/skills_award.jpeg" alt="Skills Motor Coaches Award" style="max-height: 70px; width: 70px; display: block; margin: 0 auto; border-radius: 8px;">
                            </div>
                        </a>
                    </div>
                </div>
    
            </td>
        </tr>
        <tr>
            <td style="background-color: White; width: 25%;text-align: left;">
                <font color="#007161"><font size="2px"><strong>ORIGIN:</strong><br><font size="2px"><font color="#007161">Leeds Coach & Bus Stn Dyer St</font></font><strong><br><br><font size="2px">EXPECTED DEPARTURE TIME:</strong><br><font size="2px"><font color="#007161">02-11-2024 00:20 Hrs</font></font>
            </td>
            <td style="background-color: White; width: 25%; text-align: right;">
                <font color="#007161"><font size="2px"><strong>DESTINATION:</strong><br><font size="2px"><font color="#007161">Heathrow Airport (T5) Arrivals forecourt Stops 11-15</font></font><strong><br><br><font size="2px">EXPECTED ARRIVAL TIME:</strong><br><font size="2px"><font color="#007161">02-11-2024 07:10 Hrs</font></font>
            </td>
        </tr>
        <tr>
            <td colspan="4" style="text-align: center;">
                <center>
                <font color="White"><font size="0">&copy; <?php echo date("Y"); ?> <a href="mailto:&#097;&#100;&#114;&#105;&#097;&#110;&#046;&#099;&#114;&#097;&#105;&#103;&#064;&#115;&#107;&#105;&#108;&#108;&#115;&#046;&#099;&#111;&#046;&#117;&#107;?subject=Fleet%20Tracker%20Portal" style="text-decoration: none; color: White;" target="_blank"> <b>Adrian Craig</b></a>. All rights reserved<br>Source Data: <a href="https://www.bus-data.dft.gov.uk/" target="_blank" style="text-decoration: none; color: White;"><b>UK Department for Transport</b></a><a href="tracker_natx_skills.zip">.</a></font>
                </center>
            </td>
        </tr>
    </table>
</body>
</html>
