<?php
$vehicles = [
    "BV19XPO",
    "BV19XPP",
    "BV69KRE",
    "BV69KRF",
    "BV69KRG",
    "BV73ZTL",
    "BV73ZTM",
    "BV73ZTN",
    "BV73ZTO",
    "BV73ZTP",
    "BV73ZTR",
    "BV73ZTS",
    "BV73ZTT",
    "BV73ZTU"
];
?>

// Fetch vehicle data from the remote API
$apiKey = 'e4558d582b4ecb60ec569a606a1e71cb856bfe47'; // Your API key here
$apiUrl = 'https://data.bus-data.dft.gov.uk/api/v1/datafeed/12319/?api_key=' . $apiKey;
$vehicleDataJson = file_get_contents($apiUrl);
$vehicleData = json_decode($vehicleDataJson, true);

// Prepare map markers for vehicles in the local fleet
$markers = [];
foreach ($vehicleData['VehicleActivity'] as $activity) {
    $vehicleRef = $activity['MonitoredVehicleJourney']['VehicleRef'] ?? null;
    if (in_array($vehicleRef, $vehicles)) {
        $longitude = $activity['MonitoredVehicleJourney']['VehicleLocation']['Longitude'] ?? null;
        $latitude = $activity['MonitoredVehicleJourney']['VehicleLocation']['Latitude'] ?? null;
        
        if ($longitude && $latitude) {
            $markers[] = [
                'registration' => $vehicleRef,
                'line' => $activity['MonitoredVehicleJourney']['LineRef'] ?? 'N/A',
                'longitude' => $longitude,
                'latitude' => $latitude,
                'origin' => $activity['MonitoredVehicleJourney']['OriginName'] ?? 'Unknown',
                'destination' => $activity['MonitoredVehicleJourney']['DestinationName'] ?? 'Unknown',
                'in_service' => $activity['Monitored'] ?? false,
                'recorded_at' => $activity['RecordedAtTime'] ?? 'N/A',
            ];
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Skills Motor Coaches</title>
    <style>
        body {
            background-color: #007161;
            color: #007161;
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ccc;
            padding: 10px;
            vertical-align: top;
        }
        td {
            width: 15%;
        }
        td:nth-child(1) {
            text-align: center;
            background-color: #007161;
        }
        td:nth-child(2) {
            width: 70%;
            background-color: #007161;
        }
        td:nth-child(3) {
            background-color: #007161;
            text-align: left;
        }
        #map {
            width: 100%;
            height: 500px;
        }
        .vehicle-container {
            color: #007161;
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
        }
        .vehicle-box {
            width: 45%;
            margin: 5px;
            text-align: center;
        }
        .show-all-box {
            width: calc(45% - 10px);
            margin: 5px;
            text-align: center;
        }
        .clock {
            font-family: 'Courier New', monospace;
            font-size: 32px;
            letter-spacing: 5px;
            color: #007161;
            text-align: center;
        }
    </style>
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
    <script>
        function updateClock() {
            const now = new Date();
            const hours = String(now.getHours()).padStart(2, '0');
            const minutes = String(now.getMinutes()).padStart(2, '0');
            const seconds = String(now.getSeconds()).padStart(2, '0');

            document.getElementById('clock').innerText = `${hours}:${minutes}:${seconds}`;
        }

        setInterval(updateClock, 1000);
    </script>
</head>
<body>
    <table style="color: bf7fbf; border-collapse: collapse; width: 100%;" border="0">
        <tr>
            <td colspan="2" style="background-color: White; text-align: left;">
                <div style="display: flex; align-items: center;">
                    <a href="."><img src="images/logo_skills_nx.jpg" alt="Skills Motor Coaches National Express Logo" style="max-height: 50px; width: auto; margin-right: 10px;"></a>
                    <span style="font-size: 24px; color: #007161;"><b>Fleet Tracker</b></span>
                </div>
            </td>
            <td colspan="2" style="background-color: White; text-align: right; color: #007161; vertical-align: middle;">
                <div style="display: flex; align-items: center; justify-content: flex-end;">
                    <font size="1px">Time: </font><div id="clock" class="clock" style="margin-right: 10px;"></div>
                    <font size="1px">Date: </font><div id="date" class="clock">
                    <?php 
                        date_default_timezone_set('Europe/London');
                        $currentDate = date('d-m-Y');
                        echo $currentDate;
                    ?>
                </div>
            </div>
        </td>
        </tr>
        <tr>
            <td rowspan="2">
                        <pre style="color: #ffffff; text-align: center; font-size: 24px; font-weight: bold;">S<font size="3px">elect </font>V<font size="3px">ehicle </font></pre>
                <div>
                    <input class="show-all-box" type="text" value="Show All" readonly>
                </div>
                <div class="vehicle-container">
                    <?php
                    $count = 0;
                    foreach ($vehicles as $vehicle) {
                        // Open a new row for every two registrations
                        if ($count % 2 == 0) {
                            echo '<div style="display: flex; justify-content: center; width: 100%;">';
                        }
                    ?>
                        <input class="vehicle-box" type="text" value="<?php echo htmlspecialchars($vehicle); ?>" readonly>
                    <?php
                        // Close the row after two registrations
                        if ($count % 2 == 1 || $count == count($vehicles) - 1) {
                            echo '</div>';
                        }
                        $count++;
                    }
                    ?>
                </div>
                    <br>
                    <center>
                    <a href="https://www.skills.co.uk/" target="_blank"><img src="images/skills_award.jpeg" alt="Skills Motor Coaches Award" style="max-height: 113px; width: auto; margin-right: 10px; border-radius: 20px;"></a>
                    </center>
            </td>
            <td colspan="2">
                <div id="map"></div>
                <script>
                    var map = L.map('map').setView([53.5, 1.0], 6);
                    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                        maxZoom: 19,
                        attribution: '© OpenStreetMap'
                    }).addTo(map);

                    // Add markers for the vehicles in the local fleet
                    <?php foreach ($markers as $marker): ?>
                        var marker = L.marker([<?php echo $marker['latitude']; ?>, <?php echo $marker['longitude']; ?>], { icon: L.icon({ iconUrl: 'images/red-dot.png', iconSize: [25, 41], iconAnchor: [12, 41] }) }) // Path to your red dot icon
                            .addTo(map)
                            .bindPopup("<strong>Registration:</strong> <?php echo htmlspecialchars($marker['registration']); ?><br><strong>Line:</strong> <?php echo htmlspecialchars($marker['line']); ?><br><strong>Origin:</strong> <?php echo htmlspecialchars($marker['origin']); ?><br><strong>Destination:</strong> <?php echo htmlspecialchars($marker['destination']); ?><br><strong>Recorded At:</strong> <?php echo htmlspecialchars($marker['recorded_at']); ?>");
                    <?php endforeach; ?>

                    // Fit the map to the bounds of the markers
                    var group = L.featureGroup();
                    <?php foreach ($markers as $marker): ?>
                        group.addLayer(L.marker([<?php echo $marker['latitude']; ?>, <?php echo $marker['longitude']; ?>]));
                    <?php endforeach; ?>
                    map.fitBounds(group.getBounds());
                </script>
            </td>
            <td rowspan="2">
                        <pre style="color: #ffffff; text-align: center; font-size: 24px; font-weight: bold;">T<font size="3px">racked </font>V<font size="3px">ehicle </font>D<font size="3px">ata</pre>
                <table style="width: 100%; border-collapse: collapse; text-align: left; font-size: 14px;">
                    <tr>
                        <td style="background-color: #ffffff; color: #007161; text-align: right; width: 50%; font-weight: bold;">VEHICLE:</td><td style="background-color: #007161; color: White; text-align: left;">BV73ZTO</td>
                    </tr>
                    <tr>
                        <td style="background-color: #ffffff; color: #007161; text-align: right; font-weight: bold;">LINE:</td><td style="background-color: #007161; color: White; text-align: left;">240</td>
                    </tr>
                    <tr>
                        <td style="background-color: #ffffff; color: #007161; text-align: right; font-weight: bold;">DIRECTION:</td><td style="background-color: #007161; color: White; text-align: left;">Outbound</td>
                    </tr>
                    <tr>
                        <td style="background-color: #ffffff; color: #007161; text-align: right; font-weight: bold;">LATITUDE:</td><td style="background-color: #007161; color: White; text-align: left;">53.797101</td>
                    </tr>
                    <tr>
                        <td style="background-color: #ffffff; color: #007161;text-align: right; font-weight: bold;">LONGITUDE:</td><td style="background-color: #007161; color: White; text-align: left;">-1.536084</td>
                    </tr>
                    <tr>
                        <td style="background-color: #ffffff; color: #007161; text-align: right; font-weight: bold;">REPORTED&nbsp;TIME:</td><td style="background-color: #007161; color: White; text-align: left;">12:25:19 hrs</td>
                    </tr>
                </table>
                <br>
    
                <div style="display: flex; flex-direction: column; align-items: center; gap: 0;">
                    <a href="https://nationalexpress.com/" target="_blank" style="text-decoration: none;">
                        <div style="background-color: White; color: #007161; text-align: left; padding: 10px; border-radius: 10px; border: 1px solid #007161;">
                            <img src="images/coach_icon.png" alt="National Express Logo" style="max-height: 68px; width: 68px; display: block; margin: 0 auto;">
                        </div>
                    </a>
    
                    <a href="https://www.metoffice.gov.uk/" target="_blank" style="text-decoration: none;">
                        <div style="background-color: White; color: #007161; text-align: left; padding: 10px; border-radius: 10px; border: 1px solid #007161;">
                            <img src="images/metoffice.png" alt="MetOffice" style="max-height: 68px; width: 68px; display: block; margin: 0 auto;">
                        </div>
                    </a>
    
                    <a href="https://nationalhighways.co.uk/travel-updates/road-closure-report/" target="_blank" style="text-decoration: none;">
                        <div style="background-color: White; color: #007161; text-align: left; padding: 10px; border-radius: 10px; border: 1px solid #007161;">
                            <img src="images/national-highways_rgb.svg" alt="National Highways Logo" style="max-height: 88px; width: 68px; display: block; margin: 0 auto;">
                            <center><span style="font-size: 14px;">Road<br>Closures</span></center>
                        </div>
                    </a>
                </div>
    
            </td>
        </tr>
        <tr>
            <td style="background-color: White; width: 25%;text-align: left;">
                <font color="#007161"><font size="2px"><strong>ORIGIN:</strong><br><font size="2px"><font color="#007161">Leeds Coach & Bus Stn Dyer St</font></font><strong><br><br><font size="2px">AIMED DEPARTURE TIME:</strong><br><font size="2px"><font color="#007161">02-11-2024 00:20:00 hrs</font></font>
            </td>
            <td style="background-color: White; width: 25%; text-align: right;">
                <font color="#007161"><font size="2px"><strong>DESTINATION:</strong><br><font size="2px"><font color="#007161">Heathrow Airport (T5) Arrivals forecourt Stops 11-15</font></font><strong><br><br><font size="2px">AIMED ARRIVAL TIME:</strong><br><font size="2px"><font color="#007161">02-11-2024 07:10:00 hrs</font></font>
            </td>
        </tr>
        <tr>
            <td colspan="4" style="text-align: center;">
                <center>
                <font color="White"><font size="0">&copy; <?php echo date("Y"); ?> <a href="mailto:&#097;&#100;&#114;&#105;&#097;&#110;&#046;&#099;&#114;&#097;&#105;&#103;&#064;&#115;&#107;&#105;&#108;&#108;&#115;&#046;&#099;&#111;&#046;&#117;&#107;?subject=Tracker%20Portal" style="text-decoration: none; color: White;" target="_blank"> <b>Adrian Craig</b></a>. All rights reserved<br>Source Data: <a href="https://www.bus-data.dft.gov.uk/" target="_blank" style="text-decoration: none; color: White;"><b>UK Department for Transport</b></a></font>
                </center>
            </td>
        </tr>
    </table>
</body>
</html>
